package data;

import java.util.ArrayList;
import java.util.List;

/**
 * A simple data class to hold UI properties, such as colors and text.
 */
public class UIProperties {

    /**
     * The color to be used for the battery icon.
     */
    private int batteryColorLight;
    private int batteryColorDark;
    List<String> lockNumpadKeys;

    public UIProperties() {
        // Default constructor with default values
        this.batteryColorLight = android.graphics.Color.RED;
        this.batteryColorDark = android.graphics.Color.RED;
        this.lockNumpadKeys = new ArrayList<>();
    }

    public int getBatteryColorLight() { return batteryColorLight; }
    public int getBatteryColorDark() { return batteryColorDark; }

    public List<String> getLockNumpadKeys() { return lockNumpadKeys; }

    public void setBatteryColorLight(int batteryColor) {
        this.batteryColorLight = batteryColor;
    }
    public void setBatteryColorDark(int batteryColor) { this.batteryColorDark = batteryColor; }

    public void setLockNumpadKeys(List<String> lockNumpadKeys) { this.lockNumpadKeys = lockNumpadKeys; }
}