package com.crjase.systemuihook.hooks;

import android.graphics.Color;
import android.util.Log;
import android.widget.TextView;
import java.lang.reflect.Field;
import io.github.libxposed.api.XposedInterface;
import io.github.libxposed.api.annotations.AfterInvocation;
import io.github.libxposed.api.annotations.XposedHooker;

@XposedHooker
public final class LockNumpadKeys implements XposedInterface.Hooker {
    private final static String TAG = "SystemUIHook:LockNumpadKeys";

    @AfterInvocation
    public static void afterInvocation(XposedInterface.AfterHookCallback callback) {
        try {
            Object instance = callback.getThisObject();
            if (instance == null) {
                Log.e(TAG, "SecNumPadKey instance is null.");
                return;
            }

            Class<?> secNumPadKeyClass = instance.getClass();

            // Get the mDigit field from the superclass (NumPadKey)
            Field digitField = secNumPadKeyClass.getSuperclass().getDeclaredField("mDigit");
            digitField.setAccessible(true);
            int digit = digitField.getInt(instance);

            // Get the mDigitText field from the superclass as well
            Field digitTextField = secNumPadKeyClass.getSuperclass().getDeclaredField("mDigitText");
            digitTextField.setAccessible(true);

            TextView digitTextView = (TextView) digitTextField.get(instance);

            if (digitTextView != null) {
                switch (digit) {
                    case 0:
                        digitTextView.setText("0");
                        break;
                    case 1:
                        digitTextView.setText("I");
                        break;
                    case 2:
                        digitTextView.setText("II");
                        break;
                    case 3:
                        digitTextView.setText("III");
                        break;
                    case 4:
                        digitTextView.setText("IV");
                        break;
                    case 5:
                        digitTextView.setText("V");
                        break;
                    case 6:
                        digitTextView.setText("VI");
                        break;
                    case 7:
                        digitTextView.setText("VII");
                        break;
                    case 8:
                        digitTextView.setText("VIII");
                        break;
                    case 9:
                        digitTextView.setText("IX");
                        break;
                    default:
                        digitTextView.setText(String.valueOf(digit));
                        break;
                }

                digitTextView.setTextColor(Color.GREEN);
                Log.d(TAG, "Changed text for numpad key " + digit + ".");
            }

        } catch (Exception e) {
            Log.e(TAG, "Error in LockNumpadKeysConstructor: " + e.getMessage());
        }
    }
}