package com.crjase.systemuihook.hooks;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

import data.PropertiesManager;

import io.github.libxposed.api.XposedInterface;
import io.github.libxposed.api.XposedModule;


public class HookMain extends XposedModule {

    private static HookMain module;
    public static final String TAG = "SystemUIHook";

    public HookMain(XposedInterface base, ModuleLoadedParam param) {
        super(base, param);
        log("ModuleMain at " + param.getProcessName());
        module = this;
    }


    // Helper Function to setup a constructor hook
    private void setupConstructorHook(ClassLoader classLoader, String className, Class<?>[] paramTypes, Class<? extends XposedInterface.Hooker> hookerClass) {
        try {
            Class<?> targetClass = classLoader.loadClass(className);
            Constructor<?> constructor = targetClass.getDeclaredConstructor(paramTypes);
            hook(constructor, hookerClass);
            Log.d(TAG, "Successfully set up constructor hook for " + className + ".");
        } catch (ClassNotFoundException e) {
            Log.e(TAG, "Could not find class " + className + ": " + e.getMessage(), e);
        } catch (NoSuchMethodException e) {
            Log.e(TAG, "Could not find constructor for " + className + ": " + e.getMessage(), e);
        } catch (Exception e) {
            Log.e(TAG, "An error occurred during hooking " + className + ": " + e.getMessage(), e);
        }
    }


    // New helper function to setup a method hook
    private void setupMethodHook(ClassLoader classLoader, String className, String methodName, Class<?>[] paramTypes, Class<? extends XposedInterface.Hooker> hookerClass) {
        try {
            Class<?> targetClass = classLoader.loadClass(className);
            Method method = targetClass.getDeclaredMethod(methodName, paramTypes);
            hook(method, hookerClass);
            Log.d(TAG, "Successfully set up method hook for " + className + "." + methodName);
        } catch (ClassNotFoundException e) {
            Log.e(TAG, "Could not find class " + className + ": " + e.getMessage(), e);
        } catch (NoSuchMethodException e) {
            Log.e(TAG, "Could not find method " + methodName + " for " + className + ": " + e.getMessage(), e);
        } catch (Exception e) {
            Log.e(TAG, "An error occurred during hooking " + className + "." + methodName + ": " + e.getMessage(), e);
        }
    }


    @SuppressLint({"DiscouragedPrivateApi"})
    @Override
    public void onPackageLoaded(PackageLoadedParam param) {
        super.onPackageLoaded(param);


        PropertiesManager.initialize();


        // System UI Package
        if (param.getPackageName().equals("com.android.systemui"))
        {
            Log.i(TAG, " onPackageLoaded: " + param.getPackageName());
            ClassLoader classLoader = param.getClassLoader();


            // Hook BatteryMeterView Constructor
            setupConstructorHook(
                    classLoader,
                    "com.android.systemui.battery.BatteryMeterView",
                    new Class<?>[]{Context.class, android.util.AttributeSet.class, int.class},
                    BatteryMeterView.class
            );

            // Hook SecNumPadKey's onFinishInflate method
            setupMethodHook(
                    classLoader,
                    "com.android.keyguard.SecNumPadKey",
                    "updateViewStyle",
                    new Class<?>[]{},
                    LockNumpadKeys.class
            );
        }
    }
}