package com.crjase.systemuihook.hooks;

import android.util.Log;

import data.PropertiesManager;
import data.UIProperties;

import java.lang.reflect.Field;

import io.github.libxposed.api.XposedInterface;
import io.github.libxposed.api.annotations.AfterInvocation;
import io.github.libxposed.api.annotations.XposedHooker;

@XposedHooker
public final class BatteryMeterView implements XposedInterface.Hooker {
    private final static String TAG = "SystemUIHook:BatteryMeterView";
    @AfterInvocation
    public static void afterInvocation(XposedInterface.AfterHookCallback callback) {
        try {
            // Get the newly created BatteryMeterView instance from the 'thisObject' of the callback
            Object instance = callback.getThisObject();

            // Check if the instance is not null before proceeding
            if (instance == null) {
                Log.e(TAG, "BatteryMeterView instance is null. Cannot proceed with the hook.");
                return;
            }

            // Get Properties
            UIProperties properties = PropertiesManager.getProperties();
            int batteryColorLight = properties.getBatteryColorLight();
            int batteryColorDark = properties.getBatteryColorDark();

            Log.d(TAG, "Successfully hooked BatteryMeterView constructor, Applying colors. ");

            // Get the Class of the instance
            Class<?> batteryMeterViewClass = instance.getClass();

            // Find the color fields using reflection and set them to the new color
            Field lightModeField = batteryMeterViewClass.getDeclaredField("mLightModeFillColor");
            lightModeField.setAccessible(true);
            lightModeField.setInt(instance, batteryColorLight);
            Log.d(TAG, "Changed mLightModeFillColor to " + batteryColorLight + ".");

            Field darkModeField = batteryMeterViewClass.getDeclaredField("mDarkModeFillColor");
            darkModeField.setAccessible(true);
            darkModeField.setInt(instance, batteryColorDark);
            Log.d(TAG, "Changed mDarkModeFillColor to " + batteryColorDark + ".");

        } catch (Exception e) {
            Log.e(TAG, "Error in BatteryMeterViewConstructorHooker: " + e.getMessage());
        }
    }
}