package com.crjase.systemuihook;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import com.crjase.systemuihook.databinding.ActivityMainBinding;
import com.google.android.material.button.MaterialButton;
import com.topjohnwu.superuser.Shell;

public class MainActivity extends AppCompatActivity {
    ActivityMainBinding binding;
    MaterialButton batteryActivityButton;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        binding = ActivityMainBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());



        // Make sure device has root
        verifyRoot();



        // Console clear button onClickListener
        binding.clearConsoleButton.setOnClickListener(v -> {
            binding.outputLabel.setText("");
        });



        /***********************************************************************
         *                     Card View onClickListeners                      *
         **********************************************************************/
        // Device Settings Activity
        binding.deviceSettingsActivityButton.setOnClickListener(v -> {
            // Create an AlertDialog.Builder instance
            AlertDialog.Builder builder = new AlertDialog.Builder(this);

            // Set the dialog's title and message
            builder.setTitle("Not implemented");
            builder.setMessage("This is a placeholder for a feature that I want to implement");

            // Add the "OK" button
            builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int id) {
                    // User clicked OK button
                    // You can add logic here, e.g., closing the activity
                    dialog.dismiss();
                }
            });

            // Create and show the AlertDialog
            AlertDialog dialog = builder.create();
            dialog.show();
        });

        // Battery Activity
        binding.batteryActivityButton.setOnClickListener(v -> {
            Intent intent = new Intent(MainActivity.this, BatteryActivity.class);
            startActivity(intent);
        });
    }




    /**
     * Asynchronously verifies if the app has root permissions.
     */
    private void verifyRoot() {
        // Use Shell.getShell() which is the recommended way to check for root
        // as it automatically handles the asynchronous nature of the check.
        Shell.getShell(shell -> {
            // The callback returns a 'shell' instance.
            // We can check its status to know if we have root.
            boolean hasRoot = shell.isRoot();
            logConsole("Root Status: " + (hasRoot ? "Granted" : "Denied"));

            if (!hasRoot) {
                // If root is denied, you may want to display a message to the user.
                runOnUiThread(() -> {
                    new AlertDialog.Builder(MainActivity.this)
                            .setTitle("Root Not Found")
                            .setMessage("This application requires root permissions to function. Please grant root access when prompted.")
                            .setPositiveButton("OK", null)
                            .show();
                });
            }
        });
    }


    /**
     * Logs text to the UI console, ensuring all updates are on the main thread.
     * @param text The text to be logged.
     */
    @SuppressLint("SetTextI18n")
    public void logConsole(String text) {
        // Ensure all UI updates happen on the main thread to prevent crashes.
        runOnUiThread(() -> {
            binding.outputLabel.setText(binding.outputLabel.getText().toString() + "\n" + text);
            // Auto-scroll to the bottom of the console.
            binding.consoleScrollView.post(() -> binding.consoleScrollView.fullScroll(View.FOCUS_DOWN));
        });
    }
}