package com.crjase.systemuihook;

import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import com.crjase.systemuihook.databinding.ActivityBatteryBinding;
import com.skydoves.colorpickerview.listeners.ColorListener;

import data.PropertiesManager;
import data.UIProperties;

public class BatteryActivity extends AppCompatActivity {
    ActivityBatteryBinding binding;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityBatteryBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());


        // --- Load Properties --- //
        PropertiesManager.initialize();
        UIProperties properties = PropertiesManager.getProperties();


        // --- Apply Properties to Views --- //
        int batteryColorLight = properties.getBatteryColorLight();
        int batteryColorDark = properties.getBatteryColorDark();

        ColorDrawable batteryColorLightDrawable = new ColorDrawable(batteryColorLight);
        ColorDrawable batteryColorDarkDrawable = new ColorDrawable(batteryColorDark);

        binding.lightColorPicker.setInitialColor(batteryColorLight);
        binding.darkColorPicker.setInitialColor(batteryColorDark);
        binding.lightColorDisplay.setBackground(batteryColorLightDrawable);
        binding.darkColorDisplay.setBackground(batteryColorDarkDrawable);


        binding.lightColorPicker.setColorListener(new ColorListener() {
            @Override
            public void onColorSelected(int colorLight, boolean fromUser) {
                // Update color display
                ColorDrawable colorDrawableLight = new ColorDrawable(colorLight);
                binding.lightColorDisplay.setBackground((colorDrawableLight));

                // Save to properties
                properties.setBatteryColorLight(colorLight);
                PropertiesManager.updateProperties(properties);
            }
        });

        binding.darkColorPicker.setColorListener(new ColorListener() {
            @Override
            public void onColorSelected(int colorDark, boolean fromUser) {
                // Update color display
                ColorDrawable colorDrawableDark = new ColorDrawable(colorDark);
                binding.darkColorDisplay.setBackground((colorDrawableDark));

                // Save to properties
                properties.setBatteryColorDark(colorDark);
                PropertiesManager.updateProperties(properties);
            }
        });


        binding.backButton.setOnClickListener(v -> {
            finish();
        });
    }
}