/*
 * Decompiled with CFR 0.152.
 */
package data;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.topjohnwu.superuser.Shell;
import data.UIProperties;
import java.io.File;
import java.util.List;

public final class PropertiesManager {
    private static final String TAG = "PropertiesManager";
    private static final String FILE_NAME = "properties.json";
    private static final String PACKAGE_NAME = "com.crjase.systemuihook";
    private static final String COMMON_DATA_DIR = "/data/misc/com.crjase.systemuihook";
    private static final String FILE_PATH = "/data/misc/com.crjase.systemuihook" + File.separator + "properties.json";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static UIProperties properties;

    private PropertiesManager() {
        Shell.getShell();
        PropertiesManager.loadProperties();
    }

    public static void initialize() {
        if (properties == null) {
            new PropertiesManager();
        }
    }

    private static void loadProperties() {
        Shell.cmd((String[])new String[]{"mkdir -p /data/misc/com.crjase.systemuihook"}).exec();
        List checkFileResult = Shell.cmd((String[])new String[]{"ls " + FILE_PATH}).exec().getOut();
        if (checkFileResult.isEmpty()) {
            Log.d((String)TAG, (String)"properties.json not found. Creating a new one with default values.");
            properties = new UIProperties();
            PropertiesManager.saveProperties();
        } else {
            List fileContent = Shell.cmd((String[])new String[]{"cat " + FILE_PATH}).exec().getOut();
            StringBuilder jsonContent = new StringBuilder();
            for (String line : fileContent) {
                jsonContent.append(line);
            }
            try {
                properties = (UIProperties)gson.fromJson(jsonContent.toString(), UIProperties.class);
                if (properties == null) {
                    Log.e((String)TAG, (String)"Failed to parse properties.json. Creating a new one.");
                    properties = new UIProperties();
                    PropertiesManager.saveProperties();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error loading properties file: " + e.getMessage()));
                properties = new UIProperties();
                PropertiesManager.saveProperties();
            }
        }
    }

    public static void saveProperties() {
        String json = gson.toJson((Object)properties);
        String command = "echo '" + json + "' | tee " + FILE_PATH;
        Shell.cmd((String[])new String[]{command}).exec();
        Log.d((String)TAG, (String)("Properties saved successfully to " + FILE_PATH));
    }

    public static UIProperties getProperties() {
        if (properties == null) {
            PropertiesManager.initialize();
        }
        return properties;
    }

    public static void updateProperties(UIProperties newProperties) {
        properties = newProperties;
        PropertiesManager.saveProperties();
    }
}

