/*
 * Decompiled with CFR 0.152.
 */
package com.crjase.systemuihook.hooks;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import com.crjase.systemuihook.hooks.BatteryMeterView;
import com.crjase.systemuihook.hooks.LockNumpadKeys;
import data.PropertiesManager;
import io.github.libxposed.api.XposedInterface;
import io.github.libxposed.api.XposedModule;
import io.github.libxposed.api.XposedModuleInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class HookMain
extends XposedModule {
    private static HookMain module;
    public static final String TAG = "SystemUIHook";

    public HookMain(XposedInterface base, XposedModuleInterface.ModuleLoadedParam param) {
        super(base, param);
        this.log("ModuleMain at " + param.getProcessName());
        module = this;
    }

    private void setupConstructorHook(ClassLoader classLoader, String className, Class<?>[] paramTypes, Class<? extends XposedInterface.Hooker> hookerClass) {
        try {
            Class<?> targetClass = classLoader.loadClass(className);
            Constructor<?> constructor = targetClass.getDeclaredConstructor(paramTypes);
            this.hook(constructor, hookerClass);
            Log.d((String)TAG, (String)("Successfully set up constructor hook for " + className + "."));
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Could not find class " + className + ": " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Could not find constructor for " + className + ": " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("An error occurred during hooking " + className + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void setupMethodHook(ClassLoader classLoader, String className, String methodName, Class<?>[] paramTypes, Class<? extends XposedInterface.Hooker> hookerClass) {
        try {
            Class<?> targetClass = classLoader.loadClass(className);
            Method method = targetClass.getDeclaredMethod(methodName, paramTypes);
            this.hook(method, hookerClass);
            Log.d((String)TAG, (String)("Successfully set up method hook for " + className + "." + methodName));
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Could not find class " + className + ": " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Could not find method " + methodName + " for " + className + ": " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("An error occurred during hooking " + className + "." + methodName + ": " + e.getMessage()), (Throwable)e);
        }
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    public void onPackageLoaded(XposedModuleInterface.PackageLoadedParam param) {
        super.onPackageLoaded(param);
        PropertiesManager.initialize();
        if (param.getPackageName().equals("com.android.systemui")) {
            Log.i((String)TAG, (String)(" onPackageLoaded: " + param.getPackageName()));
            ClassLoader classLoader = param.getClassLoader();
            this.setupConstructorHook(classLoader, "com.android.systemui.battery.BatteryMeterView", new Class[]{Context.class, AttributeSet.class, Integer.TYPE}, BatteryMeterView.class);
            this.setupMethodHook(classLoader, "com.android.keyguard.SecNumPadKey", "updateViewStyle", new Class[0], LockNumpadKeys.class);
        }
    }
}

