/*
 * Decompiled with CFR 0.152.
 */
package com.crjase.systemuihook;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.crjase.systemuihook.BatteryActivity;
import com.crjase.systemuihook.databinding.ActivityMainBinding;
import com.google.android.material.button.MaterialButton;
import com.topjohnwu.superuser.Shell;

public class MainActivity
extends AppCompatActivity {
    ActivityMainBinding binding;
    MaterialButton batteryActivityButton;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityMainBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.verifyRoot();
        this.binding.clearConsoleButton.setOnClickListener(v -> this.binding.outputLabel.setText((CharSequence)""));
        this.binding.deviceSettingsActivityButton.setOnClickListener(v -> {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle((CharSequence)"Not implemented");
            builder.setMessage((CharSequence)"This is a placeholder for a feature that I want to implement");
            builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.dismiss();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        });
        this.binding.batteryActivityButton.setOnClickListener(v -> {
            Intent intent = new Intent((Context)this, BatteryActivity.class);
            this.startActivity(intent);
        });
    }

    private void verifyRoot() {
        Shell.getShell(shell -> {
            boolean hasRoot = shell.isRoot();
            this.logConsole("Root Status: " + (hasRoot ? "Granted" : "Denied"));
            if (!hasRoot) {
                this.runOnUiThread(() -> new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Root Not Found").setMessage((CharSequence)"This application requires root permissions to function. Please grant root access when prompted.").setPositiveButton((CharSequence)"OK", null).show());
            }
        });
    }

    @SuppressLint(value={"SetTextI18n"})
    public void logConsole(String text) {
        this.runOnUiThread(() -> {
            this.binding.outputLabel.setText((CharSequence)(this.binding.outputLabel.getText().toString() + "\n" + text));
            this.binding.consoleScrollView.post(() -> this.binding.consoleScrollView.fullScroll(130));
        });
    }
}

