/*
 * Decompiled with CFR 0.152.
 */
package com.crjase.systemuihook;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import com.crjase.systemuihook.databinding.ActivityBatteryBinding;
import com.skydoves.colorpickerview.listeners.ColorListener;
import com.skydoves.colorpickerview.listeners.ColorPickerViewListener;
import data.PropertiesManager;
import data.UIProperties;

public class BatteryActivity
extends AppCompatActivity {
    ActivityBatteryBinding binding;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityBatteryBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        PropertiesManager.initialize();
        final UIProperties properties = PropertiesManager.getProperties();
        int batteryColorLight = properties.getBatteryColorLight();
        int batteryColorDark = properties.getBatteryColorDark();
        ColorDrawable batteryColorLightDrawable = new ColorDrawable(batteryColorLight);
        ColorDrawable batteryColorDarkDrawable = new ColorDrawable(batteryColorDark);
        this.binding.lightColorPicker.setInitialColor(batteryColorLight);
        this.binding.darkColorPicker.setInitialColor(batteryColorDark);
        this.binding.lightColorDisplay.setBackground((Drawable)batteryColorLightDrawable);
        this.binding.darkColorDisplay.setBackground((Drawable)batteryColorDarkDrawable);
        this.binding.lightColorPicker.setColorListener((ColorPickerViewListener)new ColorListener(){

            public void onColorSelected(int colorLight, boolean fromUser) {
                ColorDrawable colorDrawableLight = new ColorDrawable(colorLight);
                BatteryActivity.this.binding.lightColorDisplay.setBackground((Drawable)colorDrawableLight);
                properties.setBatteryColorLight(colorLight);
                PropertiesManager.updateProperties(properties);
            }
        });
        this.binding.darkColorPicker.setColorListener((ColorPickerViewListener)new ColorListener(){

            public void onColorSelected(int colorDark, boolean fromUser) {
                ColorDrawable colorDrawableDark = new ColorDrawable(colorDark);
                BatteryActivity.this.binding.darkColorDisplay.setBackground((Drawable)colorDrawableDark);
                properties.setBatteryColorDark(colorDark);
                PropertiesManager.updateProperties(properties);
            }
        });
        this.binding.backButton.setOnClickListener(v -> this.finish());
    }
}

